# Tape Irregularity Classifier

## Description
Implements the Technical Specification of [MPAI CAE-ARP](https://mpai.community/standards/mpai-cae/about-mpai-cae/#Figure2) *Tape Irregularity Classifier* AIM, providing:
* 2 Irregularity Files;
* Irregularity Images.

## Getting started
The *Tape Irregularity Classifier* is written in Python 3.10 which is therefore required to run the program.

## Installation
[PyYaml](https://pyyaml.org) is required for reading the configuration file. You can install it with:
```
pip install pyyaml
```
[OpenCV](https://docs.opencv.org/4.x/index.html) and [NumPy](https://numpy.org) are required for elaborating Irregularity Images. You can install them with:
```
pip install numpy
pip install opencv-contrib-python
```
Finally, [TensorFlow](https://www.tensorflow.org) is required for installing Keras and making neural network predictions. You can install it with:
```
pip install tensorflow
```

You can also use `requirements.txt` file to install all needed dependencies at once:
```
pip install -r requirements.txt
```

## Usage
Once the libraries are installed, you should customise the configuration file `config.yaml`.
There are two required parameters:
1. `WORKING_PATH` that specifies the working path where all input files are stored and where all output files will be saved;
2. `FILES_NAME` that specifies the name of the preservation files to be considered.

To execute the script without issues, the inner structure of the `WORKING_PATH` directory shall be like:
```
.
├── AccessCopyFiles
│   └── ...
├── PreservationAudioFile
│   ├── File1.wav
│   ├── File2.wav
│   └── ...
├── PreservationAudioVisualFile
│   ├── File1.mp4
│   ├── File2.mp4
│   └── ...
├── PreservationMasterFiles
│   └── ...
└── temp
    ├── File1
    │   ├── AudioAnalyser_IrregularityFileOutput1.json
    │   ├── AudioAnalyser_IrregularityFileOutput2.json
    │   ├── AudioBlocks
    │   │   ├── AudioBlock1.jpg
    │   │   ├── AudioBlock2.jpg
    │   │   └── ...
    │   ├── EditingList.json
    │   ├── IrregularityImages
    │   │   ├── IrregularityImage1.jpg
    │   │   ├── IrregularityImage2.jpg
    │   │   └── ...
    │   ├── RestoredAudioFiles
    │   │   ├── RestoredAudioFile1.wav
    │   │   ├── RestoredAudioFile2.wav
    │   │   └── ...
    │   ├── TapeIrregularityClassifier_IrregularityFileOutput1.json
    │   ├── TapeIrregularityClassifier_IrregularityFileOutput2.json
    │   ├── VideoAnalyser_IrregularityFileOutput1.json
    │   └── VideoAnalyser_IrregularityFileOutput2.json
    ├── File2
    │   ├── AudioAnalyser_IrregularityFileOutput1.json
    │   ├── AudioAnalyser_IrregularityFileOutput2.json
    │   ├── AudioBlocks
    │   │   ├── AudioBlock1.jpg
    │   │   ├── AudioBlock2.jpg
    │   │   └── ...
    │   ├── EditingList.json
    │   ├── IrregularityImages
    │   │   ├── IrregularityImage1.jpg
    │   │   ├── IrregularityImage2.jpg
    │   │   └── ...
    │   ├── RestoredAudioFiles
    │   │   ├── RestoredAudioFile1.wav
    │   │   ├── RestoredAudioFile2.wav
    │   │   └── ...
    │   ├── TapeIrregularityClassifier_IrregularityFileOutput1.json
    │   ├── TapeIrregularityClassifier_IrregularityFileOutput2.json
    │   ├── VideoAnalyser_IrregularityFileOutput1.json
    │   └── VideoAnalyser_IrregularityFileOutput2.json
    └── ...
```
`PreservationAudioFile` and `PreservationAudioVisualFile` directories contain the input of ARP Workflow, while `AccessCopyFiles` and `PreservationMasterFiles` directories contain its output. `temp` directory is used to store all files exchanged between the AIMs within the Workflow.

Please note that:
* Corresponding input files shall present the same name;
* The name of Irregularity Files given above is ***mandatory***.

With this structure, `FILES_NAME` parameter could be equal to `File1` or `File2`.

You can now launch the *Tape Irregularity Classifier* from the command line with:
```
python3 tapeIrregularityClassifier.py
```
Useful log information will be displayed during execution, requiring occasional interaction.

To enable integration in more complex workflows, it is also possible to launch the *Tape Irregularity Classifier* with command line arguments:
```
python3 tapeIrregularityClassifier.py [-h] -w WORKING_PATH -f FILES_NAME
```
If you use the `-h` flag:
```
python3 tapeIrregularityClassifier.py -h
```
all instructions will be displayed.

## Support
If you require additional information or have any problem, you can contact us at:
* Nadir Dalla Pozza (nadir.dallapozza@unipd.it);
* Niccolò Pretto (niccolo.pretto@unipd.it).

## Authors and acknowledgment
This project was developed by:
* Nadir Dalla Pozza (University of Padova);
* Niccolò Pretto (University of Padova);
* Sergio Canazza (University of Padova).

Developed with Python IDE [PyCharm Community](https://www.jetbrains.com/pycharm/).

## License
This project is licensed with [GNU GPL v3.0](https://www.gnu.org/licenses/gpl-3.0.html).
