import pytest
import tempfile
import os
import uuid

from mpai_cae_arp.types.irregularity import Irregularity, Source, IrregularityFile

from tape_irregularity_classifier import lib as tic


def test_verify_path():

    with pytest.raises(FileNotFoundError):
        working_path = ""
        files_name = ""
        tic.verify_path(working_path, files_name)
    
    with tempfile.TemporaryDirectory() as working_path:
        files_name = "test"
        os.makedirs(working_path + "/temp/" + files_name)
        assert tic.verify_path(working_path, files_name) == working_path + "/temp/" + files_name
    

def test_collect_irregularity_images():
    irregularities = []
    assert tic.collect_irregularity_images(irregularities) == []

    irregularities = [
        Irregularity(
            irregularity_ID=uuid.uuid4(),
            source=Source.VIDEO,
            time_label="00:00:00.000",
            image_URI="test1.jpg",
        )]
    assert tic.collect_irregularity_images(irregularities) == []
    assert irregularities == []


def test_get_irregularity_file():
    
    with pytest.raises(FileNotFoundError):
        tic.get_irregularity_file("")
    