import os
import subprocess

INPUT_DIR = "./"

config = {
    "file_names": os.listdir(INPUT_DIR),
    "w_eq_standard": "NAB",
    "r_eq_standard": "CCIR",
    "w_speed": "7.5",
    "r_speed": "7.5"
}

if __name__ == '__main__':
    for filename in config["file_names"]:
        if not os.path.exists(INPUT_DIR + "/temp"):
            os.makedirs(INPUT_DIR + "/temp")
        subprocess.run(["python3", "tapeAudioRestoration.py", "-w", INPUT_DIR, "-f", filename, "-ew", config["w_eq_standard"], "-sw", config["w_speed"], "-sr", config["r_speed"], "-er", config["r_eq_standard"]])
