# Tape Audio Restoration

## Description
Implements the Technical Specification of [MPAI CAE-ARP](https://mpai.community/standards/mpai-cae/about-mpai-cae/#Figure2) *Tape Audio Restoration* AIM, providing:
* Restored Audio Files;
* Editing List.

## Getting started
The *Tape Audio Restoration* is written in Python 3.9 which is therefore required to run the program.

## Installation
[PyYaml](https://pyyaml.org) is required for reading the configuration file. You can install it with:
```
pip install pyyaml
```
[Control](https://python-control.readthedocs.io/en/0.9.3.post2/index.html), [NumPy](https://numpy.org) and [SciPy](https://scipy.org) are required for correcting the audio of the Preservation Audio File. You can install them with:
```
pip install control
pip install numpy
pip install scipy
```
Finally, [Matplotlib](https://matplotlib.org) is required for (optionally) plotting the frequency responses of the filters. You can install it with:
```
pip install matplotlib
```

You can also use `requirements.txt` file to install all needed dependencies at once:
```
pip install -r requirements.txt
```

## Usage
Once the libraries are installed, you should customise the configuration file `config.yaml`.
There are nine required parameters:
1. `WORKING_PATH` that specifies the working path where all input files are stored and where all output files will be saved;
2. `FILES_NAME` that specifies the name of the Preservation Audio File to be considered. Use an empty string 
to plot filter frequency response;
3. `STANDARD_W` that specifies the equalisation standard used to record the tape;
4. `SPEED_W` that specifies the speed used when recording the tape;
5. `STANDARD_R` that specifies the equalisation standard used to read the tape;
6. `SPEED_R` that specifies the speed used when reading the tape.

To execute the script without issues, the inner structure of the `WORKING_PATH` directory shall be like:
```
.
├── AccessCopyFiles
│   └── ...
├── PreservationAudioFile
│   ├── File1.wav
│   ├── File2.wav
│   └── ...
├── PreservationAudioVisualFile
│   ├── File1.mp4
│   ├── File2.mp4
│   └── ...
├── PreservationMasterFiles
│   └── ...
└── temp
    ├── File1
    │   ├── AudioAnalyser_IrregullarityFileOutput1.json
    │   ├── AudioAnalyser_IrregullarityFileOutput2.json
    │   ├── AudioBlocks
    │   │   ├── AudioBlock1.jpg
    │   │   ├── AudioBlock2.jpg
    │   │   └── ...
    │   ├── EditingList.json
    │   ├── IrregularityImages
    │   │   ├── IrregularityImage1.jpg
    │   │   ├── IrregularityImage2.jpg
    │   │   └── ...
    │   ├── RestoredAudioFiles
    │   │   ├── RestoredAudioFile1.wav
    │   │   ├── RestoredAudioFile2.wav
    │   │   └── ...
    │   ├── TapeIrregularityClassifier_IrregularityFileOutput1.json
    │   ├── TapeIrregularityClassifier_IrregularityFileOutput2.json
    │   ├── VideoAnalyser_IrregularityFileOutput1.json
    │   └── VideoAnalyser_IrregularityFileOutput2.json
    ├── File2
    │   ├── AudioAnalyser_IrregullarityFileOutput1.json
    │   ├── AudioAnalyser_IrregullarityFileOutput2.json
    │   ├── AudioBlocks
    │   │   ├── AudioBlock1.jpg
    │   │   ├── AudioBlock2.jpg
    │   │   └── ...
    │   ├── EditingList.json
    │   ├── IrregularityImages
    │   │   ├── IrregularityImage1.jpg
    │   │   ├── IrregularityImage2.jpg
    │   │   └── ...
    │   ├── RestoredAudioFiles
    │   │   ├── RestoredAudioFile1.wav
    │   │   ├── RestoredAudioFile2.wav
    │   │   └── ...
    │   ├── TapeIrregularityClassifier_IrregularityFileOutput1.json
    │   ├── TapeIrregularityClassifier_IrregularityFileOutput2.json
    │   ├── VideoAnalyser_IrregularityFileOutput1.json
    │   └── VideoAnalyser_IrregularityFileOutput2.json
    └── ...
```
`PreservationAudioFile` and `PreservationAudioVisualFile` directories contain the input of ARP Workflow, while `AccessCopyFiles` and `PreservationMasterFiles` directories contain its output. `temp` directory is used to store all files exchanged between the AIMs within the Workflow.

Please note that:
* Corresponding input files shall present the same name;
* The name of Irregularity Files given above is ***mandatory***.

With this structure, `FILES_NAME` parameter could be equal to `File1` or `File2`.

You can now launch the *Tape Audio Restoration* from the command line with:
```
python3 tapeAudioRestoration.py
```
Useful log information will be displayed during execution, requiring occasional interaction.

## Support
If you require additional information or have any problem, you can contact us at:
* Nadir Dalla Pozza (nadir.dallapozza@unipd.it);
* Niccolò Pretto (niccolo.pretto@unipd.it).

## Authors and acknowledgment
This project was developed by:
* Nadir Dalla Pozza (University of Padova);
* Niccolò Pretto (University of Padova);
* Sergio Canazza (University of Padova).

This project takes advantage of the following libraries:
* [Control](https://python-control.readthedocs.io/en/0.9.3.post2/index.html);
* [Matplotlib](https://matplotlib.org);
* [NumPy](https://numpy.org);
* [PyYaml](https://pyyaml.org);
* [SciPy](https://scipy.org).

Developed with Python IDE [PyCharm Community](https://www.jetbrains.com/pycharm/).

## License
This project is licensed with [GNU GPL v3.0](https://www.gnu.org/licenses/gpl-3.0.html).
