"""
n of each DS
Inputs:
    - DS1: Preservation Audio File
    - DS2: Preservation Audio-Visual File
    - DS3: Restored Audio Files 
    - DS4: Editing List 
    - DS5: Irregularity File
    - DS6: Irregularity Images

Outputs:
    - DS7: Access Copy Files
    - DS8: Preservation Master Files 
"""

# TODO implement table 36 output
# TODO replace file_name and to for each

import shutil
from pathlib import Path
import pytest

working_dir = Path("..")


def test_test():
    assert True is True


@pytest.fixture
def run_packager():
    return NotImplementedError  # TODO


def test_access_copy_files(tmp_path):
    raf_path = Path(working_dir/"AccessCopyFiles/file_name/RestoredAudioFiles")
    el_path = Path(working_dir/"AccessCopyFiles/file_name/EditingList.json")
    if_path = Path(working_dir/"AccessCopyFiles/file_name/IrregularityFile.json")
    ii_path = Path(working_dir/"AccessCopyFiles/file_name/IrregularityImages.zip")

    # test paths exist
    assert raf_path.is_dir(), "RestoredAudioFiles not found"
    assert el_path.is_file(), "EditingList.json not found"
    assert if_path.is_file(), "IrregularityFile.json not found"
    assert ii_path.is_file(), "IrregularityImages.zip not found"

    # test RestoredAudioFiles are the same as input

    # test EditList.json and IrregularityFile.json are the same as input

    # unpack IrregularityImages.zip and test images are the same as input
    shutil.unpack_archive(ii_path, tmp_path / "IrregularityImages", "zip")


def test_preservation_master_files(tmp_path):
    if_path = Path(working_dir/"AccessCopyFiles/file_name/IrregularityFile.json")
    ii_path = Path(working_dir/"AccessCopyFiles/file_name/IrregularityImages.zip")
    paf_path = Path(working_dir/"AccessCopyFiles/file_name/PreservationAudioFile.waw")
    pavf_path = Path(working_dir/"AccessCopyFiles/file_name/PreservationAudioVisualFile.mov")

    # test paths exist
    assert if_path.is_file(), "IrregularityFile.json not found"
    assert ii_path.is_file(), "IrregularityImages.zip not found"
    assert paf_path.is_file(), "PreservationAudioFile.waw not found"
    assert pavf_path.is_file(), "PreservationAudioVisualFile.mov not found"
