# Packager

## Description
Implements MPAI CAE-ARP (https://mpai.community/standards/mpai-cae/about-mpai-cae/#Figure2) Packager Technical Specification, providing:
- Access Copy Files:
  1. Restored Audio Files.
  2. Editing List.
  3. Set of Irregularity Images in a .zip file.
  4. Irregularity File.
- Preservation Master Files:
  1. Preservation Audio File.
  2. Preservation Audio-Visual File where the audio has been replaced with the Audio of the Preservation Audio File
     fully synchronised with the video.
  3. Set of Irregularity Images in a .zip file.
  4. Irregularity File.

## Getting started
The Packager is written in Python 3.9 which is therefore required to run the program.

## Installation
PyYaml (https://pyyaml.org) is required for reading the configuration file. You can install it with:
```
pip install pyyaml
```
MoviePy (https://zulko.github.io/moviepy/) is required for replacing the audio of the Preservation Audio-Visual File. You can install it with:
```
pip install moviepy
```

You can also use `requirements.txt` file to install all needed dependencies at once:
```
pip install -r requirements.txt
```

## Usage
Once the libraries are installed, you should customise the configuration file `config.yaml`.
There are two required parameters:
1) `WORKING_PATH` that specifies the working path where all input files are stored and where all output files will be saved;
2) `PRESERVATION_FILES_NAME` that specifies the name of the preservation files to be considered.

You can now launch the Packager from the command line with:
```
python3 main.py
```
Useful log information will be displayed during execution, requiring occasional interaction.

## Support
If you have any problem you can contact us at:
- Nadir Dalla Pozza (nadir.dallapozza@unipd.it)
- Niccolò Pretto (niccolo.pretto@unipd.it)

## Authors and acknowledgment
This project was developed by:
- Nadir Dalla Pozza (Università degli Studi di Padova)
- Niccolò Pretto (Università degli Studi di Padova)
- Sergio Canazza (Università degli Studi di Padova)

This project takes advantage of with the following libraries:
- MoviePy (https://zulko.github.io/moviepy/)
- PyYaml (https://pyyaml.org)

Developed with Python IDE PyCharm Community (https://www.jetbrains.com/pycharm/).

## License
This project is licensed with GNU GPL v3.0.
