from uuid import uuid4
import numpy as np

from mpai_cae_arp.types.irregularity import Irregularity, Source
from mpai_cae_arp.audio import AudioWave, Noise
from mpai_cae_arp.time import frames_to_seconds


def calculate_offset(audio: AudioWave, video: AudioWave) -> float:
    """
    Calculates the offset between two audio files based on their cross-correlation.

    Parameters
    ----------
    audio : AudioWave
        The audio file to be used as reference.
    video : AudioWave
        The audio file to be used as target.
    
    Returns
    -------
    float
    """

    corr = np.correlate(audio.array, video.array, mode="full")
    lags = np.arange(-len(audio.array) + 1, len(video.array))
    lag_idx = np.argmax(np.abs(corr))

    return lags[lag_idx] / audio.sample_rate


def foo():
    input = AudioWave.from_file("input.wav")
    input_channels: list[AudioWave] = []
    for channel in input.channels:
        input_channels.append(input.get_channel(channel))

    for audio in input_channels:
        for chunk in audio.get_silence_slices([Noise("A", -50, -63), Noise("B", -63, -69), Noise("C", -69, -72)], 500):

            Irregularity(
                uuid=uuid4(),
                source=Source.AUDIO,
                time_label=frames_to_seconds
            )
