from fastapi import FastAPI

from mpai_cae_arp.files import File, FileType
from mpai_cae_arp.types.irregularity import IrregularityFile
from mpai_cae_arp.types.schema import Info

info = File('config/server.yaml', FileType.YAML).get_content()

app = FastAPI(**info)


@app.get('/')
async def get_endpoints_list() -> list[str]:
    """Get list of all endpoints."""
    return [route.path for route in app.routes]


@app.get('/description')
async def get_description() -> Info:
    """Get description of the server."""
    return info


@app.get('/irregularityFile/{id}')
async def get_irregularity_file(id: int) -> IrregularityFile:
    """Get irregularity file by id."""
    return IrregularityFile(irregularities=[], offset=150)