# MPAI-CAE ARP Workflow

[![MPAI-CAE ARP](https://img.shields.io/badge/MPAI%20CAE--ARP-gray?style=for-the-badge&logo=AppleMusic&logoColor=cyan&link=https://mpai.community/standards/mpai-cae/about-mpai-cae/)](https://mpai.community/standards/mpai-cae/about-mpai-cae/)

This is the repository containing the MPAI-CAE ARP workflow implementation. The workflow is composed of the following steps:
1. Audio and video analysis;
2. Video irregularity classification;
3. Tape audio restoration;
4. Packaging.

The workflow is implemented as a set of docker containers, each one performing a specific task. The containers are orchestrated by docker-compose. Once the composition is started, the containers will communicate with each other through a shared volume, which will be used to store the intermediate results of the workflow. The starting point of the workflow is a client application, which will specify the input path. The client and the workflow containers communicate via gRPC.

## Requirements

The following software is required to run the workflow:
* Docker;
* Docker-compose;
* Python 3.10 or higher.
* poetry

## Installation
To install the workflow, clone the repository with (you may need to install git first, and request access to the repository):
```bash
git clone https://gitlab.dei.unipd.it/mpai/workflow.git
```

Then, since the workflow has been developed in many repositories (one for each step), you need to clone the submodules with:
```bash
git submodule update --init --recursive
```

Once the repository is cloned, you need to build the docker images. To do so start docker and run:
```bash
docker compose up -d
```

On the first run, docker will download the base images and build the custom ones. This may take a while.
If everithing went fine, you should be to see the containers running with:
```bash
docker ps
```

To install the client application, you need to install poetry with:
```bash
pip install poetry
```

Then, you can install the client application by fisrt moving to the client directory:
```bash
cd client
```

And then running:
```bash
poetry install
```

## Usage

If the containers are not running, you can start them with:
```bash
docker compose up -d
```

To run the client application, you need to move to the client directory:
```bash
cd client
```

And then run:
```bash
poetry run mpai-cae-arp -h
```
It will show the help message with some instructions on how to use the client application:
```
usage: mpai-cae-arp [-h] -f FILES_NAME [-s HOST]

The MPAI-CAE ARP client.

options:
  -h, --help            show this help message and exit
  -f FILES_NAME, --files-name FILES_NAME
                        Specify the name of the Preservation files (without extension)
  -s HOST, --host HOST  Specify the host of the server (default is localhost)
```

The application expects to find the input files in the `data` directory, that is shared with the containers and should have the following structure:
```
data
├── PreservationAudioFile
│   ├── BERIO052.wav
│   └── BERIO100.wav
└── PreservationAudioVisualFile
    ├── BERIO052.mov
    └── BERIO100.mov
```

## Support
If you require additional information or have any problem running the software, please contact us at:
* Matteo Spanio (dev2@audioinnova.com)

## Authors and acknowledgment
This project was developed by:
* Nadir Dalla Pozza (University of Padova);
* Niccolò Pretto (University of Padova);
* Sergio Canazza (University of Padova).

## License
This project is licensed with [GNU GPL v3.0](https://www.gnu.org/licenses/gpl-3.0.html).
