import json
import yaml


def get_file_content(file_name: str, format: str) -> dict:

    with open(file_name) as fd:
        if format == "yaml":
            content = yaml.safe_load(fd)
            return content
        elif format == "json":
            content = json.load(fd)
        else:
            raise ValueError("Format not supported")

        return content
