# AI Framework

Workflow: ![workflow](_pics/workflow.jpg)

Entity and context understanding: ![entities](_pics/entities.jpg)

Tested on NVIDIA GeForce RTX 3080.

## Models

| Module     | Library                                                                | GPU           |
| :---       | :---                                                                   |    :---       |
| osd_tvs    | ffmpeg                                                                 | No            |
| mmc_aus    | [pyannote.audio](https://github.com/pyannote/pyannote-audio)           | Yes           |
| osd_vcd    | [PySceneDetect](https://github.com/Breakthrough/PySceneDetect)                                                                        | No            |
| mmc_asr    | [whisper-timestamped](https://github.com/linto-ai/whisper-timestamped) | Yes           |
| mmc_sir    | [SpeechBrain](https://github.com/speechbrain/speechbrain)              | Yes           |
| paf_fir    | [DeepFace](https://github.com/serengil/deepface)                       | Yes           |


## Docker commands

Run
```
docker compose --env-file .env.template -f compose.yml up
```

## GPU drivers

NVIDIA driver: ![package](_pics/additional_drivers.png)

## Troubleshooting

If you get error message 
```
docker: Error response from daemon: could not select device driver "nvidia" with capabilities: [[gpu]]
```
run
```
sudo apt-get install -y nvidia-docker2
sudo systemctl restart docker
```
