# MPAI-NNW v1.2 implementation 
## Case 4
This code refers to the NN-based image classification methods specifically designed and deployed for low power and low resources devices, as described in [TBC] https://mpai.community/.. . It aims to prove that Neural Network Watermarking (NNW) approach under standardization by Moving Pictures, Audio and Data Coding by Artificial Intelligence (MPAI) community is the solution for protecting intellectual property such as the tiny Neural Network (NN), deployable on resource-constrained devices. The standard is named IEEE 3304-2023.

We start with the MLCommon Tiny benchmark model for Image Classification (ResNet8) (https://mlcommons.org/) and watermark it with a state-of-the-art method. Later on we explore its robustness and efficiency through a series of tests. These tests include attack simulations such as quantization, pruning, and Gaussian attacks done following the MPAI NNW standardazed procedure.

By subjecting the mentioned neural networks to these tests, we aim to learn more about the trade-offs between parameters, accuracy, and computational costs, ultimately facilitating the deployment of robust, efficient and secure machine learning solutions on Micro Controller Units (MCUs) for various edge computing applications by embedding a watermark. 
For MCUs deployability analysis, ST Edge AI Unified Core Technology has been used.

All the code is based in Python and delivered as a standalone Python Notebook.

**Folders**
- **pics** stores all the pics 
- **model** stores all the Neural Network (NN) models

## Installation
Code was designed and tested on an WSL ubuntu 20.04 using venv and Python 3.9.13.

An environment with all the necessary libraries can be created using venv and installign the required packages following:
```bash
/path/to/python3.9.13/script -m venv /path/to/your/env
source /path/to/your/env/bin/activate
pip install -r requirements.txt
```

ST Edge AI Core shall be installed to run the inferences on the MCU and the instruction can be found here: https://stm32ai.st.com/

## Run
The user that wants to replicate the procedure using the notebook can easily walkthrough of the file after activating the environment:
```bash
source /path/to/your/env/bin/activate
```

Please, in the third to last cell insert the path to your ST Edge AI installation to run the code on the mcu.
An exemplary path is presented in the variable "xcubeai_exe_path" and only the prefix the variable "HOME" could be needed.

In the latest cell two exemplary dict with the option to run inferences on MCU and to embed the watermark are presented.
The user can easily run all the cell to obtain the results.

# Licence
Copyright 2024 STMicroelectronics

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
