# MPAI-NNW v1.2 implementation 
## Case 3


This code refers to the implementation of the MPAI-NNW under MPAI-AIF, as described in [TBC] https://mpai.community/wp-content/uploads/2023/10/Reference-Software-Neural-Network-Watermarking-V1.pdf.
All the code is based in Python.

**Implemented APIs**
1. MPAI_AIFS_GetAndParseArchive, unzip and parse json and AIMs.
2. MPAI_AIFM_AIM_{Start,Pause,Resume,Stop,GetStatus}, to process on AIM/AIW. 
3. MPAI_AIFM_Port_Input_{Write,Read,Reset}, to process on the port of the AIMs.

**Controller/User Agent**
1. Controller is deployed under the socket library (waiting request from _input.py_).
2. User Agent can trigger and run command by sending inputs.
3. _config.py_ shares some variables among the different files.

**Folders**
- **all_AIW** stores all the different AIW that are implemented 
  - NNW_NNW-QAM,NNW_NNW-QAM-Checker for the Multimodal Question Answering watermarking use case
- **resources** external elements for some use cases (uncorrelated images for ADI, context/question of the MQA, ...)

## Installation
Code was designed and tested on an Ubuntu 20.04 operating system using anaconda 23.7.2 and Python 3.9.
An environment with all the necessary libraries can be created using:
```bash
conda create --name <env> --file requirements.txt
```

## Run
**Initialisation**
First the Controller should be initialized (the command '-W ignore' can be added to avoid warning message during execution):
```bash
conda activate <env>
python controller.py
Controller Initialized
```
To send commands to the controller as a user agent, 
a second terminal should be open, and run:
```bash
conda activate <env>
python input.py
input: <your command>
```

**Emulation of MPAI Store**

Emulate the folder of the computer as a website using the command:
```bash
python3 -m http.server
```
Then the command simulate the downloading of the AIW from a website:
```bash
conda activate <env>
python input.py
input: wget http://0.0.0.0:8000/[yourpath]/AIW.zip
```

### **List of command for controller**

This command will open a window for the selection of the AIW.zip folder:
```bash
(env) python input.py
input: getparse
```
This command will run the AIW (after being parsed): 
```bash
(env) python input.py
input: run all
```
windows using tkinter will ask for the different files.

### Some warnings
1. The AIW should be named AIW.zip and contained the .json and the needed AIMs.
2. The code does not permit misspelling.

# Licence
[Licence](https://mpai.community/standards/mpai-nnw/framework-licence/) information are detailed in the MPAI website 
