# MPAI-NNW v1.2 implementation 
## Case 1


This code refers to the implementation of the MPAI-NNW, as described in https://mpai.community/wp-content/uploads/2023/10/Reference-Software-Neural-Network-Watermarking-V1.pdf.
All the code is based in Python. 
Case 1 resents a direct implementation of the NNW Technical Specification.

### Folders
The structure of case 1 is as followed:
- **Imperceptibility.py**, **Robustness.py**, **ComputationalCost.py** implement the different Evaluation presented in the Technical Specification.
  - *Imperceptibility.py* evaluates imperceptibility by training and evaluate the trained model on a testing dataset
  - *Robustness.py* evaluates the robustness of the given method by selecting a modification **M_ID=1** Modification and **{"P":0.5}** Parameters
  - *Computational_cost* evaluates the computational cost of the method in terms of GPU memory and time of execution
- **utils.py** contains the common functions required for Evaluation.
- **Attacks** folder stores 7 files that implement the 7 Modifications involved in the Robustness Evaluation.
- **NNWfolder** stores a file for each watermarking method, a Python class that possesses three main functions (init, embedder/embedder_one_step, detectore/decoder).
- **Resources** folder contains additional resources for the watermarking methods and pretrained weights.

## Installation
Code was designed and tested on an Ubuntu 20.04 operating system using anaconda 23.7.2 and Python 3.9.
An environment with all the necessary libraries can be created using:
```bash
conda create --name <env> --file requirements.txt
```

## Run
All modifications should be applied inside the three files (**Imperceptibility.py**, **Robustness.py**, **ComputationalCost.py**). The "to be modified" section are delimited by ####### while the code can be run:
```bash
conda activate <env>
python Imperceptibility.py
```
To send commands to the controller as a user agent, 
a second terminal should be open, and run:
```bash
conda activate <env>
python input.py
input: <your command>
```
Watermarking methods can be added in the NNW folder following the instruction specified in the technical specification (Python Class).

# Licence
[Licence](https://mpai.community/standards/mpai-cui/framework-licence/) information are detailed in the MPAI website 
