using UnityEngine;
using UnityEngine.Networking;
using System.Collections;
using System;

// UnityWebRequest.Get example

// Access a website and use UnityWebRequest.Get to download a page.
// Also try to download a non-existing page. Display the error.

public class Example : MonoBehaviour
{
    void Start()
    {
        Debug.Log("Client started\n");


        //StartCoroutine(GetRequest("https://localhost:7162/weatherforecast"));
        //StartCoroutine(GetRequest("https://localhost:7162/api/TodoItems"));
        //StartCoroutine(Upload("https://localhost:7162/api/TodoItems"));

        StartCoroutine(GetRequest("https://localhost:7096/api/Books"));


    }

    IEnumerator GetRequest(string uri)
    {
        using (UnityWebRequest webRequest = UnityWebRequest.Get(uri))
        {
            // Request and wait for the desired page.
            yield return webRequest.SendWebRequest();

            string[] pages = uri.Split('/');
            int page = pages.Length - 1;

            switch (webRequest.result)
            {
                case UnityWebRequest.Result.ConnectionError:
                case UnityWebRequest.Result.DataProcessingError:
                    Debug.LogError(pages[page] + ": Error: " + webRequest.error);
                    break;
                case UnityWebRequest.Result.ProtocolError:
                    Debug.LogError(pages[page] + ": HTTP Error: " + webRequest.error);
                    break;
                case UnityWebRequest.Result.Success:
                    Debug.Log(pages[page] + ":\nReceived: " + webRequest.downloadHandler.text);
                    break;
            }
        }
    }


    IEnumerator Upload(string uri)
    {
        using (UnityWebRequest www = UnityWebRequest.Post(uri, "{ \"name\": \"playing\", \"isComplete\": true }", "application/json"))
        {
            yield return www.SendWebRequest();

            if (www.result != UnityWebRequest.Result.Success)
            {
                Debug.LogError(www.error);
            }
            else
            {
                Debug.Log("Form upload complete!");
            }
        }
    }

}